# Recber Tesisat Web Sitesi Tasarım Fikirleri

## Fikir 1: Modern Endüstriyel Minimalizm

<response>
<text>
**Design Movement**: Endüstriyel minimalizm ile İskandinav tasarım estetiğinin birleşimi

**Core Principles**:
- Temiz geometrik formlar ve net çizgiler
- Fonksiyonellik odaklı tasarım dili
- Güçlü tipografi hiyerarşisi
- Malzeme dürüstlüğü (beton, metal, su tekstürleri)

**Color Philosophy**: 
Soğuk endüstriyel tonlar - koyu antrasit gri (#2C3E50) ana renk, turkuaz mavi (#16A085) vurgu rengi, açık beton gri (#ECF0F1) arka plan. Renk paleti su ve metal malzemelerin doğal tonlarını yansıtır, güven ve profesyonellik hissi verir.

**Layout Paradigm**: 
Asimetrik grid sistemi - sol tarafa ağırlık veren düzen, büyük beyaz alanlar, diyagonal kesimler ve örtüşen katmanlar. Her bölüm farklı açılardan birbirine geçer.

**Signature Elements**:
- Diyagonal kesimli bölüm geçişleri (clip-path kullanımı)
- Şeffaf overlay'ler ile derinlik
- Teknik çizim tarzı ikonlar

**Interaction Philosophy**: 
Hassas ve amaca yönelik - hover'da ince çizgi animasyonları, butona tıklamada ripple efekti, scroll'da parallax ile derinlik hissi. Her etkileşim endüstriyel hassasiyeti yansıtır.

**Animation**: 
Mekanik ve hassas - linear-easing ile robotik hareketler, fade-in yerine slide-in animasyonlar, sayaçlarda count-up efekti, bölüm geçişlerinde stagger animasyonları.

**Typography System**: 
Heading: "Rajdhani" (bold, geometric, endüstriyel) - ana başlıklar için
Body: "Inter" (regular/medium) - okunabilirlik için
Accent: "Bebas Neue" (uppercase) - etiketler ve küçük başlıklar için
</text>
<probability>0.08</probability>
</response>

## Fikir 2: Organik Akışkan Tasarım

<response>
<text>
**Design Movement**: Bio-morphic design ile fluid interface tasarımının sentezi

**Core Principles**:
- Yumuşak, akan formlar ve organik şekiller
- Su temasını görsel dile dönüştürme
- Doğal renkler ve yumuşak geçişler
- Hareket ve akışkanlık hissi

**Color Philosophy**: 
Su elementinden ilham alan gradient'lar - derin okyanus mavisi (#0A4D68) ile açık turkuaz (#88D4AB) arası akıcı geçişler, kum beji (#F2E3DB) nötr ton, mercan turuncu (#FF6B6B) CTA rengi. Palet su döngüsünün sakinleştirici ve temizleyici doğasını temsil eder.

**Layout Paradigm**: 
Blob-based asimetrik layout - her bölüm organik blob şekilleriyle çerçevelenir, içerik dalgalı yollar boyunca akar, bento-box grid yerine serbest form yerleşim.

**Signature Elements**:
- SVG blob şekilleri ve morph animasyonları
- Glassmorphism kartlar (backdrop-blur)
- Sıvı dalga animasyonları (CSS/SVG)

**Interaction Philosophy**: 
Yumuşak ve doğal - elastic easing ile bounce efektleri, hover'da blob şekil değişimi, scroll'da wave animasyonları. Etkileşimler suyun akışını taklit eder.

**Animation**: 
Akıcı ve organik - cubic-bezier easing ile yumuşak geçişler, morph animasyonları, floating efektleri, gradient animasyonları, ripple efektleri.

**Typography System**: 
Heading: "Poppins" (semibold/bold, yuvarlatılmış) - dostça ve modern
Body: "DM Sans" (regular) - temiz ve okunabilir
Accent: "Quicksand" (medium) - yumuşak ve dostane
</text>
<probability>0.07</probability>
</response>

## Fikir 3: Brutalist Tekno-Utilitarian

<response>
<text>
**Design Movement**: Digital brutalism ile Swiss typography'nin karışımı

**Core Principles**:
- Çıplak, süslenmemiş arayüz elementleri
- Kalın border'lar ve net ayrımlar
- Maksimum kontrast ve okunabilirlik
- "Form follows function" felsefesi

**Color Philosophy**: 
Yüksek kontrastlı palet - saf siyah (#000000) ve beyaz (#FFFFFF) temel, elektrik yeşili (#00FF41) sistem mesajları için, tehlike kırmızısı (#FF0000) acil durumlar için. Renk sadece bilgi iletmek için kullanılır, dekoratif değil.

**Layout Paradigm**: 
Modüler grid sistemi - sert kenarlı kutular, belirgin grid çizgileri, terminal benzeri bölümler, tablo düzenleri. Her element kendi sınırlarını net gösterir.

**Signature Elements**:
- Kalın siyah border'lar (3-4px)
- Monospace font kullanımı
- Terminal/command-line estetiği

**Interaction Philosophy**: 
Anında ve net - transition yok veya çok kısa (50ms), hover'da renk değişimi, tıklamada inset shadow, loading için ASCII animasyonlar. Her durum değişimi açıkça görünür.

**Animation**: 
Minimal ve fonksiyonel - step easing ile keskin geçişler, blink animasyonları, glitch efektleri, scan-line efektleri. Animasyon sadece durum değişikliğini gösterir.

**Typography System**: 
Heading: "Space Grotesk" (bold, geometric) - güçlü ve net
Body: "IBM Plex Mono" (regular) - teknik ve okunabilir
Accent: "Space Mono" (bold) - sistem mesajları için
</text>
<probability>0.09</probability>
</response>

## Seçilen Tasarım: Modern Endüstriyel Minimalizm

Tesisat firması için en uygun tasarım yaklaşımı **Modern Endüstriyel Minimalizm** olarak seçildi. Bu yaklaşım:

- Profesyonellik ve güvenilirlik hissini güçlü şekilde iletir
- Su ve metal malzemelerin doğal estetiğini yansıtır
- Teknik uzmanlığı görsel dille destekler
- Temiz ve modern bir görünüm sunar
- Kullanıcı deneyimini fonksiyonellik üzerine kurar

### Uygulama Detayları

**Renk Paleti**:
- Primary: #16A085 (turkuaz - güven ve su teması)
- Dark: #2C3E50 (antrasit gri - profesyonellik)
- Light: #ECF0F1 (beton gri - temizlik)
- Accent: #E74C3C (turuncu-kırmızı - acil durum CTA)

**Tipografi**:
- Başlıklar: Rajdhani (Bold 700, SemiBold 600)
- Gövde: Inter (Regular 400, Medium 500)
- Vurgular: Bebas Neue (Regular 400, uppercase)

**Layout Özellikleri**:
- Asimetrik grid yapısı
- Diyagonal bölüm geçişleri
- Örtüşen katmanlar
- Geniş beyaz alanlar
- Sol tarafa ağırlık veren kompozisyon
