/* Design Philosophy: Modern Industrial Minimalism
   - Card-based testimonial layout
   - Star ratings with customer feedback
*/

import { Card, CardContent } from "@/components/ui/card";
import { Star } from "lucide-react";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel";

interface Testimonial {
  name: string;
  platform: string;
  rating: number;
  comment: string;
}

export default function Testimonials() {
  const testimonials: Testimonial[] = [
    {
      name: "Fahri B. K.",
      platform: "Armut",
      rating: 5,
      comment: "2 senedir iç mimarlık yapıyorum şimdiye kadar çalıştığım en iyi usta kendisi. Kişiliği ve çalışkanlığı takdire şayan.",
    },
    {
      name: "Metin Erol",
      platform: "Google",
      rating: 5,
      comment: "İşinin ehli bir firma zamanında iş çözücü. Kesinlikle tavsiye ederim.",
    },
    {
      name: "Ersin Güler",
      platform: "Google",
      rating: 5,
      comment: "Güvenilir, garantili hizmet için tavsiye ederim. Çok memnun kaldık.",
    },
    {
      name: "Baran Korkmaz",
      platform: "Armut",
      rating: 5,
      comment: "Tıkalı giderlerimiz vardı Reçber tesisat sayesinde açıldı. Kerem abi sağ olsun.",
    },
    {
      name: "Ahmet T.",
      platform: "Armut",
      rating: 5,
      comment: "Çok memnun kaldık teşekkür ederiz. Profesyonel ve hızlı çözüm.",
    },
    {
      name: "Kaplan C.",
      platform: "Armut",
      rating: 5,
      comment: "Doğalgaz, su işinizmi var, tercih edeceginiz ki KEREM usta olsun, kesinlikle memnun kalacaksınız.",
    },
    {
      name: "n ****",
      platform: "Armut",
      rating: 5,
      comment: "Son derece mütevazi ve kibarlar. İşlerinin ehli ve arkasında duran, fiyatı makul, çok iyi bir usta Kerem bey.",
    },
    {
      name: "Aydın S. K.",
      platform: "Armut",
      rating: 5,
      comment: "Randevuya dediği saatte geldi sessizce işini yaptı fiyat uygun temiz işçilik beş yıldız veriyorum.",
    },
  ];

  return (
    <section className="py-20 bg-background">
      <div className="container">
        {/* Section Header */}
        <div className="text-center max-w-3xl mx-auto mb-16">
          <span className="text-accent-caps text-primary text-sm">Müşteri Yorumları</span>
          <h2 className="text-4xl md:text-5xl font-bold mt-2 mb-4 text-foreground">
            Sizden Gelen <span className="text-accent">Yorumlar</span>
          </h2>
          <p className="text-muted-foreground text-lg">
            Müşterilerimizin memnuniyeti bizim için en önemli başarı göstergesidir.
          </p>
        </div>

        {/* Testimonials Carousel */}
        <Carousel
          opts={{
            align: "start",
            loop: true,
          }}
          className="w-full"
        >
          <CarouselContent className="-ml-4">
            {testimonials.map((testimonial, index) => (
              <CarouselItem key={index} className="pl-4 md:basis-1/2 lg:basis-1/3">
                <Card className="h-full border-2 hover:border-primary/50 transition-colors">
                  <CardContent className="p-6 flex flex-col h-full">
                    {/* Stars */}
                    <div className="flex gap-1 mb-4">
                      {Array.from({ length: testimonial.rating }).map((_, i) => (
                        <Star key={i} className="w-5 h-5 fill-yellow-400 text-yellow-400" />
                      ))}
                    </div>

                    {/* Comment */}
                    <p className="text-muted-foreground mb-6 flex-grow">
                      "{testimonial.comment}"
                    </p>

                    {/* Author */}
                    <div className="flex items-center gap-3 pt-4 border-t border-border">
                      <div className="w-10 h-10 bg-primary/20 rounded-full flex items-center justify-center">
                        <span className="text-primary font-bold text-lg">
                          {testimonial.name.charAt(0)}
                        </span>
                      </div>
                      <div>
                        <div className="font-semibold text-foreground">{testimonial.name}</div>
                        <div className="text-sm text-accent">{testimonial.platform}</div>
                      </div>
                    </div>
                  </CardContent>
                </Card>
              </CarouselItem>
            ))}
          </CarouselContent>
          <CarouselPrevious className="hidden md:flex" />
          <CarouselNext className="hidden md:flex" />
        </Carousel>
      </div>
    </section>
  );
}
