/* Design Philosophy: Modern Industrial Minimalism
   - Grid layout with service cards
   - Technical imagery with overlay effects
   - Teal accent colors for CTAs
*/

import { Button } from "@/components/ui/button";
import { Card, CardContent, CardFooter, CardHeader } from "@/components/ui/card";
import { MessageCircle, Phone, Droplet, Flame, WashingMachine, Wrench, Waves, AlertCircle } from "lucide-react";

export default function Services() {
  const services = [
    {
      icon: Droplet,
      title: "Su Kaçağı Tespiti",
      description: "Termal kamera ve akustik cihazlarla kırmadan su kaçağı tespiti. Profesyonel ekipman ile hızlı ve kesin sonuç.",
      image: "/images/service-leak-detection.png",
    },
    {
      icon: Flame,
      title: "Kombi Bakımı",
      description: "Düzenli kombi bakımı ile enerji tasarrufu ve uzun ömür. Tüm marka ve modellerde uzman servis hizmeti.",
      image: "/images/service-boiler.png",
    },
    {
      icon: WashingMachine,
      title: "Tuvalet Tıkanıklığı Açma",
      description: "Robotla kırmadan tuvalet tıkanıklığı açma. Modern ekipmanlarla hızlı ve temiz çözüm.",
      image: "/images/service-drain-cleaning.png",
    },
    {
      icon: Wrench,
      title: "Lavabo Tıkanıklığı Açma",
      description: "Sürekli tıkanan lavabolar için kalıcı çözüm. Robotla %100 kırmadan lavabo açma hizmeti.",
      image: "/images/service-drain-cleaning.png",
    },
    {
      icon: Waves,
      title: "Tıkalı Boru Açma",
      description: "Spiral makine ve yüksek basınçlı su ile tıkalı boru açma. Garantili ve hızlı servis.",
      image: "/images/service-leak-detection.png",
    },
    {
      icon: AlertCircle,
      title: "Pimaş Tıkanıklığı Açma",
      description: "Pimaş ve foseptik tıkanıklıklarında profesyonel çözüm. Modern ekipmanlarla hijyenik temizlik.",
      image: "/images/service-drain-cleaning.png",
    },
  ];

  return (
    <section id="services" className="py-20 bg-muted/30 relative">
      {/* Diagonal Top Transition */}
      <div className="absolute top-0 left-0 right-0 h-24 bg-background" style={{ clipPath: 'polygon(0 0, 100% 80%, 100% 100%, 0 100%)' }} />
      
      <div className="container relative z-10 pt-12">
        {/* Section Header */}
        <div className="text-center max-w-3xl mx-auto mb-16 animate-slide-in-left">
          <span className="text-accent-caps text-primary text-sm">Hizmetlerimiz</span>
          <h2 className="text-4xl md:text-5xl font-bold mt-2 mb-4 text-foreground">
            Profesyonel Tesisat Çözümleri
          </h2>
          <p className="text-muted-foreground text-lg">
            Modern ekipman ve uzman kadromuzla 7/24 hizmetinizdeyiz. Tüm tesisat sorunlarınız için garantili çözümler sunuyoruz.
          </p>
        </div>

        {/* Services Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6 mb-12">
          {services.map((service, index) => {
            const Icon = service.icon;
            return (
              <Card 
                key={index} 
                className="group hover:shadow-xl transition-all duration-300 hover:-translate-y-1 border-2 hover:border-primary/50 bg-card animate-slide-in-left overflow-hidden"
                style={{ animationDelay: `${index * 0.1}s` }}
              >
                {/* Image */}
                <div className="relative h-48 overflow-hidden">
                  <img
                    src={service.image}
                    alt={service.title}
                    className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-secondary/90 to-transparent" />
                  <div className="absolute bottom-4 left-4">
                    <div className="w-12 h-12 bg-primary rounded-sm flex items-center justify-center">
                      <Icon className="w-6 h-6 text-primary-foreground" />
                    </div>
                  </div>
                </div>

                <CardHeader>
                  <h3 className="text-xl font-bold text-foreground group-hover:text-primary transition-colors">
                    {service.title}
                  </h3>
                </CardHeader>

                <CardContent>
                  <p className="text-muted-foreground">
                    {service.description}
                  </p>
                </CardContent>

                <CardFooter className="flex gap-2">
                  <a href="https://wa.me/905324456921" target="_blank" rel="noopener noreferrer" className="flex-1">
                    <Button variant="outline" className="w-full" size="sm">
                      <MessageCircle className="w-4 h-4 mr-2" />
                      WhatsApp
                    </Button>
                  </a>
                  <a href="tel:+902163121715" className="flex-1">
                    <Button className="w-full bg-primary hover:bg-primary/90" size="sm">
                      <Phone className="w-4 h-4 mr-2" />
                      Ara
                    </Button>
                  </a>
                </CardFooter>
              </Card>
            );
          })}
        </div>

        {/* View All Button */}
        <div className="text-center">
          <Button size="lg" variant="outline" className="border-2 border-primary text-primary hover:bg-primary hover:text-primary-foreground">
            Tüm Hizmetleri İncele
          </Button>
        </div>
      </div>

      {/* Diagonal Bottom Transition */}
      <div className="absolute bottom-0 left-0 right-0 h-24 bg-background" style={{ clipPath: 'polygon(0 0, 100% 20%, 100% 100%, 0 100%)' }} />
    </section>
  );
}
