/* Design Philosophy: Modern Industrial Minimalism
   - Grid layout for service regions
   - Expandable district sections
*/

import { MapPin } from "lucide-react";
import { Button } from "@/components/ui/button";

export default function Regions() {
  const regions = [
    {
      name: "Ataşehir",
      services: [
        "Su kaçağı Tespit",
        "Tuvalet Tıkanıklık Açma",
        "Kombi Servisi",
        "Lavabo Tıkanıklık Açma",
        "Tıkalı Boru Açma",
        "Pimaş Tıkanıklığı Açma",
      ],
    },
    {
      name: "Beykoz",
      services: [
        "Kombi Servisi",
        "Kombi Temizliği",
        "Lavabo Tıkanıklık Açma",
        "Petek Temizliği",
        "Pimaş Tıkanıklığı Açma",
        "Su kaçağı Tespit",
      ],
    },
    {
      name: "Çekmeköy",
      services: [
        "Kombi Servisi",
        "Su kaçağı Tespit",
        "Tıkanıklık Açma",
        "Kanal Temizliği",
        "Petek Temizliği",
        "Acil Tesisat",
      ],
    },
    {
      name: "Kartal",
      services: [
        "Kombi Servisi",
        "Su Tesisatçısı",
        "Tıkanıklık Açma",
        "Su kaçağı Tespit",
        "Petek Temizliği",
        "Acil Servis",
      ],
    },
    {
      name: "Maltepe",
      services: [
        "Kombi Servisi",
        "Su kaçağı Tespit",
        "Tıkanıklık Açma",
        "Lavabo Açma",
        "Petek Temizliği",
        "Acil Tesisat",
      ],
    },
    {
      name: "Sancaktepe",
      services: [
        "Kombi Servisi",
        "Su Tesisatçısı",
        "Tıkanıklık Açma",
        "Su kaçağı Tespit",
        "Petek Temizliği",
        "Acil Servis",
      ],
    },
    {
      name: "Sultanbeyli",
      services: [
        "Su Tesisatçısı",
        "Su kaçağı Tespit",
        "Tıkanıklık Açma",
        "Kombi Servisi",
        "Petek Temizliği",
        "Acil Tesisat",
      ],
    },
    {
      name: "Ümraniye",
      services: [
        "Kombi Servisi",
        "Su kaçağı Tespit",
        "Tıkanıklık Açma",
        "Su Tesisatçısı",
        "Petek Temizliği",
        "Acil Servis",
      ],
    },
  ];

  return (
    <section id="regions" className="py-20 bg-gradient-to-br from-primary via-secondary to-primary relative overflow-hidden">
      {/* Technical Pattern Overlay */}
      <div className="absolute inset-0 technical-pattern opacity-5" />
      
      <div className="container relative z-10">
        {/* Section Header */}
        <div className="text-center max-w-3xl mx-auto mb-16">
          <span className="text-accent-caps text-white/80 text-sm">Hizmet Alanlarımız</span>
          <h2 className="text-4xl md:text-5xl font-bold mt-2 mb-4 text-white">
            Hizmet Bölgelerimiz
          </h2>
          <p className="text-white/80 text-lg">
            İstanbul'un birçok ilçesinde 7/24 profesyonel tesisat hizmeti sunuyoruz.
          </p>
        </div>

        {/* Regions Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
          {regions.map((region, index) => (
            <div
              key={index}
              className="bg-white/10 backdrop-blur-sm rounded-sm p-6 border border-white/20 hover:bg-white/15 transition-all duration-300 hover:-translate-y-1"
            >
              <div className="flex items-center gap-3 mb-4">
                <div className="w-10 h-10 bg-white/20 rounded-sm flex items-center justify-center">
                  <MapPin className="w-5 h-5 text-white" />
                </div>
                <h3 className="text-xl font-bold text-white" style={{ fontFamily: 'Rajdhani, sans-serif' }}>
                  {region.name}
                </h3>
              </div>
              <ul className="space-y-2">
                {region.services.map((service, idx) => (
                  <li key={idx} className="text-white/80 text-sm flex items-start gap-2">
                    <span className="text-white mt-1">▸</span>
                    <span>{service}</span>
                  </li>
                ))}
              </ul>
            </div>
          ))}
        </div>

        {/* CTA */}
        <div className="text-center mt-12">
          <p className="text-white/90 mb-4 text-lg">
            Bölgenizi göremiyor musunuz? Bizi arayın, size yardımcı olalım!
          </p>
          <a href="tel:+902163121715">
            <Button size="lg" className="bg-white text-secondary hover:bg-white/90">
              Hemen Arayın: 0 (216) 312 17 15
            </Button>
          </a>
        </div>
      </div>
    </section>
  );
}
