/* Design Philosophy: Modern Industrial Minimalism
   - Asymmetric layout with left-weighted composition
   - Technical pattern background with overlay
   - Diagonal transitions and overlapping layers
*/

import { Button } from "@/components/ui/button";
import { Phone, MessageCircle } from "lucide-react";

export default function Hero() {
  return (
    <section id="home" className="relative min-h-screen flex items-center overflow-hidden pt-32 pb-20">
      {/* Technical Pattern Background */}
      <div className="absolute inset-0 technical-pattern opacity-10" />
      
      {/* Gradient Overlay */}
      <div className="absolute inset-0 bg-gradient-to-br from-secondary/90 via-primary/80 to-secondary/90" />
      
      {/* Content */}
      <div className="container relative z-10">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Left Content */}
          <div className="text-white space-y-6 animate-slide-in-left">
            {/* Accent Label */}
            <div className="inline-block">
              <span className="text-accent-caps text-primary bg-primary/20 px-4 py-2 rounded-sm text-sm border border-primary/30">
                İstanbul Genelinde 7/24 Hizmet
              </span>
            </div>
            
            {/* Main Heading */}
            <h1 className="text-5xl md:text-6xl lg:text-7xl font-bold leading-tight">
              <span className="block text-white">Profesyonel</span>
              <span className="block text-primary">Petek Temizliği</span>
              <span className="block text-white">Kombi Verimini</span>
              <span className="block text-primary">%30 Arttırır</span>
            </h1>
            
            {/* Description */}
            <div className="space-y-4 text-lg text-white/90 max-w-2xl">
              <p>
                Reçber Tesisat olarak İstanbul genelinde makineli ve kimyasal ilaçlı profesyonel petek temizliği hizmeti sunuyoruz. Peteklerin ısınmaması, kombinin fazla yakması, doğalgaz faturalarının artması gibi sorunları cihazlı petek temizleme yöntemiyle hızlı şekilde çözüyoruz.
              </p>
              <p>
                Petekleriniz yarım ısınıyor, bazı odalar soğuk kalıyor veya kombi sürekli çalışmasına rağmen ısıtmıyorsa profesyonel ekiplerimiz 7/24 yanınızdadır.
              </p>
            </div>
            
            {/* Services List */}
            <div className="space-y-2 text-white/90">
              <p className="font-semibold text-white text-lg mb-3">Hizmetlerimiz:</p>
              <ul className="space-y-2 ml-4">
                <li className="flex items-start gap-2">
                  <span className="text-primary mt-1">▸</span>
                  <span>Makineli petek temizliği</span>
                </li>
                <li className="flex items-start gap-2">
                  <span className="text-primary mt-1">▸</span>
                  <span>Kimyasal ilaçlı petek temizliği</span>
                </li>
                <li className="flex items-start gap-2">
                  <span className="text-primary mt-1">▸</span>
                  <span>Kombide verim artırma uygulamaları</span>
                </li>
                <li className="flex items-start gap-2">
                  <span className="text-primary mt-1">▸</span>
                  <span>Isıtma sistemi bakım ve temizliği</span>
                </li>
              </ul>
            </div>
            
            {/* CTA Buttons */}
            <div className="flex flex-wrap gap-4 pt-4">
              <a href="https://wa.me/905324456921" target="_blank" rel="noopener noreferrer">
                <Button size="lg" className="bg-primary hover:bg-primary/90 text-primary-foreground text-lg px-8 py-6">
                  <MessageCircle className="w-5 h-5 mr-2" />
                  WhatsApp Destek Hattı
                </Button>
              </a>
              <a href="tel:+902163121715">
                <Button size="lg" variant="outline" className="bg-white/10 hover:bg-white/20 text-white border-white/30 text-lg px-8 py-6 backdrop-blur-sm">
                  <Phone className="w-5 h-5 mr-2" />
                  Bizi Arayın
                </Button>
              </a>
            </div>
          </div>
          
          {/* Right Image */}
          <div className="relative animate-slide-in-right stagger-2 hidden lg:block">
            <div className="relative">
              {/* Decorative Elements */}
              <div className="absolute -top-8 -right-8 w-64 h-64 bg-primary/20 rounded-sm blur-3xl" />
              <div className="absolute -bottom-8 -left-8 w-64 h-64 bg-accent/20 rounded-sm blur-3xl" />
              
              {/* Main Image */}
              <div className="relative z-10 rounded-sm overflow-hidden border-4 border-primary/30 shadow-2xl">
                <img
                  src="/images/hero-technician.png"
                  alt="Profesyonel Tesisat Teknisyeni"
                  className="w-full h-auto object-cover"
                />
              </div>
              
              {/* Accent Badge */}
              <div className="absolute -bottom-6 -left-6 bg-accent text-white px-6 py-4 rounded-sm shadow-lg z-20 border-2 border-white">
                <div className="text-accent-caps text-sm">Garantili</div>
                <div className="text-2xl font-bold" style={{ fontFamily: 'Rajdhani, sans-serif' }}>10 Yıl</div>
                <div className="text-sm">Tecrübe</div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      {/* Diagonal Bottom Transition */}
      <div className="absolute bottom-0 left-0 right-0 h-24 bg-background" style={{ clipPath: 'polygon(0 100%, 100% 100%, 100% 0, 0 80%)' }} />
    </section>
  );
}
