/* Design Philosophy: Modern Industrial Minimalism
   - Clean footer with company info
   - Dark background with teal accents
*/

import { Facebook, Twitter, Instagram, Youtube } from "lucide-react";

export default function Footer() {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="bg-secondary text-secondary-foreground">
      <div className="container py-12">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 mb-8">
          {/* Company Info */}
          <div>
            <div className="flex items-center gap-3 mb-4">
              <div className="w-10 h-10 bg-primary rounded-sm flex items-center justify-center">
                <span className="text-primary-foreground font-bold text-xl" style={{ fontFamily: 'Rajdhani, sans-serif' }}>R</span>
              </div>
              <span className="font-bold text-lg" style={{ fontFamily: 'Rajdhani, sans-serif' }}>REÇBER TESİSAT</span>
            </div>
            <p className="text-secondary-foreground/80 text-sm mb-4">
              İstanbul genelinde profesyonel tesisat hizmetleri. 10 yıllık deneyim, garantili işçilik.
            </p>
            <div className="flex gap-3">
              <a href="#" className="w-8 h-8 bg-white/10 rounded-sm flex items-center justify-center hover:bg-primary transition-colors" aria-label="Facebook">
                <Facebook className="w-4 h-4" />
              </a>
              <a href="#" className="w-8 h-8 bg-white/10 rounded-sm flex items-center justify-center hover:bg-primary transition-colors" aria-label="Twitter">
                <Twitter className="w-4 h-4" />
              </a>
              <a href="#" className="w-8 h-8 bg-white/10 rounded-sm flex items-center justify-center hover:bg-primary transition-colors" aria-label="Instagram">
                <Instagram className="w-4 h-4" />
              </a>
              <a href="#" className="w-8 h-8 bg-white/10 rounded-sm flex items-center justify-center hover:bg-primary transition-colors" aria-label="YouTube">
                <Youtube className="w-4 h-4" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="font-bold text-lg mb-4" style={{ fontFamily: 'Rajdhani, sans-serif' }}>Hızlı Bağlantılar</h3>
            <ul className="space-y-2 text-sm">
              <li>
                <a href="#home" className="text-secondary-foreground/80 hover:text-primary transition-colors">
                  Anasayfa
                </a>
              </li>
              <li>
                <a href="#about" className="text-secondary-foreground/80 hover:text-primary transition-colors">
                  Hakkımızda
                </a>
              </li>
              <li>
                <a href="#services" className="text-secondary-foreground/80 hover:text-primary transition-colors">
                  Hizmetlerimiz
                </a>
              </li>
              <li>
                <a href="#regions" className="text-secondary-foreground/80 hover:text-primary transition-colors">
                  Hizmet Bölgelerimiz
                </a>
              </li>
              <li>
                <a href="#contact" className="text-secondary-foreground/80 hover:text-primary transition-colors">
                  İletişim
                </a>
              </li>
            </ul>
          </div>

          {/* Services */}
          <div>
            <h3 className="font-bold text-lg mb-4" style={{ fontFamily: 'Rajdhani, sans-serif' }}>Hizmetlerimiz</h3>
            <ul className="space-y-2 text-sm">
              <li className="text-secondary-foreground/80">Su Kaçağı Tespiti</li>
              <li className="text-secondary-foreground/80">Kombi Bakımı</li>
              <li className="text-secondary-foreground/80">Tıkanıklık Açma</li>
              <li className="text-secondary-foreground/80">Petek Temizliği</li>
              <li className="text-secondary-foreground/80">Acil Tesisat Servisi</li>
            </ul>
          </div>

          {/* Contact */}
          <div>
            <h3 className="font-bold text-lg mb-4" style={{ fontFamily: 'Rajdhani, sans-serif' }}>İletişim</h3>
            <ul className="space-y-2 text-sm">
              <li className="text-secondary-foreground/80">
                <a href="tel:+902163121715" className="hover:text-primary transition-colors">
                  0 (216) 312 17 15
                </a>
              </li>
              <li className="text-secondary-foreground/80">
                <a href="tel:+905324456921" className="hover:text-primary transition-colors">
                  0532 445 69 21
                </a>
              </li>
              <li className="text-secondary-foreground/80">
                <a href="mailto:info@recber-tesisat.com" className="hover:text-primary transition-colors">
                  info@recber-tesisat.com
                </a>
              </li>
              <li className="text-secondary-foreground/80">
                İstanbul - Anadolu Yakası
              </li>
            </ul>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-white/10 pt-8 flex flex-col md:flex-row justify-between items-center gap-4 text-sm text-secondary-foreground/60">
          <p>
            Copyright © {currentYear} Recber Tesisat. Tüm Hakları Saklıdır.
          </p>
          <p>
            Geliştirici: <span className="text-primary">Manus AI</span>
          </p>
        </div>
      </div>
    </footer>
  );
}
