/* Design Philosophy: Modern Industrial Minimalism
   - Fixed floating action buttons for quick contact
*/

import { Button } from "@/components/ui/button";
import { Phone, MessageCircle, ArrowUp } from "lucide-react";
import { useEffect, useState } from "react";

export default function FloatingButtons() {
  const [showScrollTop, setShowScrollTop] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setShowScrollTop(window.scrollY > 500);
    };

    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const scrollToTop = () => {
    window.scrollTo({ top: 0, behavior: "smooth" });
  };

  return (
    <>
      {/* WhatsApp Button */}
      <a
        href="https://wa.me/905324456921"
        target="_blank"
        rel="noopener noreferrer"
        className="fixed bottom-24 right-6 z-40 group"
        aria-label="WhatsApp ile iletişime geç"
      >
        <Button
          size="icon"
          className="w-14 h-14 rounded-full bg-[#25D366] hover:bg-[#20BA5A] text-white shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-110"
        >
          <MessageCircle className="w-6 h-6" />
        </Button>
        <span className="absolute right-16 top-1/2 -translate-y-1/2 bg-secondary text-white px-3 py-1 rounded text-sm whitespace-nowrap opacity-0 group-hover:opacity-100 transition-opacity pointer-events-none">
          WhatsApp
        </span>
      </a>

      {/* Phone Button */}
      <a
        href="tel:+902163121715"
        className="fixed bottom-6 right-6 z-40 group"
        aria-label="Telefon ile ara"
      >
        <Button
          size="icon"
          className="w-14 h-14 rounded-full bg-primary hover:bg-primary/90 text-primary-foreground shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-110"
        >
          <Phone className="w-6 h-6" />
        </Button>
        <span className="absolute right-16 top-1/2 -translate-y-1/2 bg-secondary text-white px-3 py-1 rounded text-sm whitespace-nowrap opacity-0 group-hover:opacity-100 transition-opacity pointer-events-none">
          Ara
        </span>
      </a>

      {/* Scroll to Top Button */}
      {showScrollTop && (
        <button
          onClick={scrollToTop}
          className="fixed bottom-6 left-6 z-40 group"
          aria-label="Yukarı çık"
        >
          <Button
            size="icon"
            variant="outline"
            className="w-12 h-12 rounded-full bg-accent hover:bg-accent/90 text-white border-none shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-110"
          >
            <ArrowUp className="w-5 h-5" />
          </Button>
        </button>
      )}
    </>
  );
}
