/* Design Philosophy: Modern Industrial Minimalism
   - Clean layout with technical imagery
   - Left-weighted asymmetric composition
*/

import { Button } from "@/components/ui/button";
import { CheckCircle2 } from "lucide-react";

export default function About() {
  const features = [
    "10 yıllık sektör deneyimi",
    "Uzman ve sertifikalı ekip",
    "Modern teknoloji ve ekipman",
    "7/24 acil servis hizmeti",
    "Garantili işçilik",
    "Şeffaf fiyatlandırma",
  ];

  return (
    <section id="about" className="py-20 bg-background">
      <div className="container">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Left Image */}
          <div className="relative animate-slide-in-left">
            <div className="relative rounded-sm overflow-hidden shadow-2xl border-2 border-border">
              <img
                src="/images/service-leak-detection.png"
                alt="Su Kaçağı Tespiti - Termal Kamera"
                className="w-full h-auto object-cover"
              />
              {/* Overlay Badge */}
              <div className="absolute top-6 left-6 bg-primary text-primary-foreground px-6 py-3 rounded-sm shadow-lg">
                <div className="text-accent-caps text-xs">Robotla</div>
                <div className="text-xl font-bold" style={{ fontFamily: 'Rajdhani, sans-serif' }}>%100 Kırmadan</div>
                <div className="text-sm">Lavabo Açma</div>
              </div>
            </div>
          </div>

          {/* Right Content */}
          <div className="space-y-6 animate-slide-in-right stagger-2">
            {/* Section Label */}
            <div>
              <span className="text-accent-caps text-primary text-sm">Hakkımızda</span>
              <h2 className="text-4xl md:text-5xl font-bold mt-2 text-foreground">
                Güvenilir ve Profesyonel Tesisat Çözümleri
              </h2>
            </div>

            {/* Description */}
            <div className="space-y-4 text-muted-foreground text-lg">
              <p>
                Recber Tesisat, su tıkanıklık açma ve su kaçağı bulma konularında uzmanlaşmış bir tesisat firmasıdır. 10 yıllık birikimi ve deneyimi ile sektörde kendine sağlam bir yer edinmiştir. Müşteri memnuniyetini ön planda tutan anlayışıyla, müşterilerine kaliteli ve güvenilir hizmet sunmaktadır.
              </p>
              <p>
                Tesisat alanında geniş bir tecrübeye sahip firmamız, su tıkanıklıkları ve su kaçakları gibi sorunların tespiti ve çözümü konularında uzmanlaşmış bir ekip tarafından yönetilmektedir. En son teknolojiyi kullanarak sorunlara hızlı ve etkili çözümler sunmayı hedeflemekteyiz.
              </p>
            </div>

            {/* Features Grid */}
            <div className="grid sm:grid-cols-2 gap-4 pt-4">
              {features.map((feature, index) => (
                <div key={index} className="flex items-start gap-3">
                  <CheckCircle2 className="w-6 h-6 text-primary flex-shrink-0 mt-0.5" />
                  <span className="text-foreground font-medium">{feature}</span>
                </div>
              ))}
            </div>

            {/* CTA */}
            <div className="pt-4">
              <Button size="lg" className="bg-secondary hover:bg-secondary/90 text-secondary-foreground">
                Daha Fazla Bilgi
              </Button>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
